/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.comp.FocuslessDirectionButton;
import DE.siemens.ad.logo.app.comp.IncrementableIntegerJTextField;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.ButtonReleasedListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditableNumericSpinner
extends JPanel
implements ButtonReleasedListener,
MouseWheelListener {
    protected Vector numericSpinnerListeners = new Vector();
    protected FocuslessDirectionButton upButton;
    protected FocuslessDirectionButton downButton;
    protected IncrementableIntegerJTextField numberField;
    protected SymAction lSymAction;
    protected SymText lSymText;
    protected JSlider slider;
    protected JButton sliderButton;
    protected boolean sliderActivated = false;

    public EditableNumericSpinner() {
        super.setLayout(new GridBagLayout());
        this.upButton = new FocuslessDirectionButton();
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this.upButton, gbc);
        this.downButton = new FocuslessDirectionButton();
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this.downButton, gbc);
        this.numberField = this.getNumberField();
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 2;
        this.add((Component)this.numberField, gbc);
        this.sliderButton = new JButton();
        this.sliderButton.setMargin(new Insets(0, 0, 0, 0));
        this.sliderButton.setFocusPainted(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 2;
        this.add((Component)this.sliderButton, gbc);
        this.sliderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EditableNumericSpinner.this.sliderButtonPressed();
            }
        });
        this.slider = new JSlider();
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                EditableNumericSpinner.this.sliderChanged(e);
            }
        });
        ImageIcon upIcon = Global.getIcon("UpArrow.gif");
        ImageIcon downIcon = Global.getIcon("DownArrow.gif");
        this.downButton.setIcon(downIcon);
        this.upButton.setIcon(upIcon);
        this.sliderButton.setText("I");
        this.setSliderActive(true);
    }

    protected IncrementableIntegerJTextField getNumberField() {
        if (this.numberField == null) {
            this.numberField = new IncrementableIntegerJTextField();
            this.numberField.setColumns(4);
        }
        return this.numberField;
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.lSymAction = new SymAction();
        this.upButton.addActionListener(this.lSymAction);
        this.downButton.addActionListener(this.lSymAction);
        this.lSymText = new SymText();
        this.numberField.getDocument().addDocumentListener(this.lSymText);
        this.upButton.addButtonReleasedListener(this);
        this.downButton.addButtonReleasedListener(this);
        this.numberField.addMouseWheelListener(this);
    }

    public synchronized void addNumericSpinnerListener(NumericSpinnerListener l) {
        this.numericSpinnerListeners.addElement(l);
    }

    public void buttonReleased() {
        this.numberField.requestFocus();
    }

    public boolean checkChanged() {
        return this.numberField.checkChanged();
    }

    public boolean checkValue(boolean notify) {
        return this.numberField.checkValue(notify);
    }

    public LogoError createDefaultError() {
        return this.numberField.createDefaultError();
    }

    void downButton_actionPerformed(ActionEvent event) {
        this.numberField.Dec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireSpinnerChangedEvent(DocumentEvent event) {
        Vector l;
        SpinnerChangedEvent sce = new SpinnerChangedEvent(this);
        EditableNumericSpinner editableNumericSpinner = this;
        synchronized (editableNumericSpinner) {
            l = (Vector)this.numericSpinnerListeners.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            ((NumericSpinnerListener)l.elementAt(i)).spinnerChanged(sce);
        }
    }

    public LogoError getError() {
        return this.numberField.getError();
    }

    public int getFirstDelay() {
        return this.upButton.getFirstDelay();
    }

    public int getIncrement() {
        return this.numberField.getIncrement();
    }

    public int getMax() {
        return this.numberField.getMax();
    }

    public int getMin() {
        return this.numberField.getMin();
    }

    public Dimension getMinimalSize() {
        return this.getPreferredSize();
    }

    public int getPeriodicDelay() {
        return this.upButton.getPeriodicDelay();
    }

    public int getValue() {
        return this.numberField.getValue();
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public boolean isSliderActive() {
        return this.sliderActivated;
    }

    public synchronized void removeNotify() {
        this.upButton.removeActionListener(this.lSymAction);
        this.downButton.removeActionListener(this.lSymAction);
        this.numberField.getDocument().removeDocumentListener(this.lSymText);
        this.upButton.removeButtonReleasedListener(this);
        this.downButton.removeButtonReleasedListener(this);
        super.removeNotify();
    }

    public void removeNumericSpinnerListener(NumericSpinnerListener l) {
        this.numericSpinnerListeners.removeElement(l);
    }

    public void requestFocus() {
        this.numberField.requestFocus();
    }

    public void setColumns(int columns) {
        this.numberField.setColumns(columns);
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.numberField.setEnabled(state);
        this.upButton.setEnabled(state);
        this.downButton.setEnabled(state);
        this.sliderButton.setEnabled(state);
    }

    public void setError(LogoError errorMessage) {
        this.numberField.setError(errorMessage);
    }

    public void setFirstDelay(int value) {
        this.upButton.setFirstDelay(value);
        this.downButton.setFirstDelay(value);
    }

    public void setIncrement(int value) {
        this.numberField.setIncrement(value);
    }

    public void setInitialValue(int value) {
        this.numberField.setInitialValue(value);
    }

    public void setLayout(LayoutManager mgr) {
    }

    public void setMax(int value) {
        this.numberField.setMax(value);
    }

    public void setMin(int value) {
        this.numberField.setMin(value);
    }

    public void setMinMax(int min, int max) {
        this.numberField.setMinMax(min, max);
    }

    public void setPeriodicDelay(int value) {
        this.upButton.setPeriodicDelay(value);
        this.downButton.setPeriodicDelay(value);
    }

    public IntValueProperties getValueProperties() {
        IntValueProperties valueProperties = new IntValueProperties(this.getMin(), this.getMax(), this.getIncrement(), this.getValue(), "error.dialog.invalidValue", "Invalid Value");
        return valueProperties;
    }

    public void setProperties(IntValueProperties ivp) {
        this.setMin(ivp.getMin());
        this.setMax(ivp.getMax());
        this.setIncrement(ivp.getInc());
        this.setInitialValue(ivp.getCurrentValue());
        this.setError(this.numberField.createError(ivp.getErrorKey(), ivp.getDefaultErrorText()));
        this.setToolTipText(Language.getString("comp.spinner.tooltip", "Please enter a value between " + ivp.getMin() + " and " + ivp.getMax() + ".", new Object[]{new Integer(ivp.getMin()), new Integer(ivp.getMax())}));
    }

    public void setPropertiesWithoutCurrent(IntValueProperties ivp) {
        this.setMin(ivp.getMin());
        this.setMax(ivp.getMax());
        this.setIncrement(ivp.getInc());
        this.setError(this.numberField.createError(ivp.getErrorKey(), ivp.getDefaultErrorText()));
    }

    public void setSliderActive(boolean newSliderActivated) {
        this.sliderActivated = newSliderActivated;
        this.sliderButton.setVisible(this.sliderActivated);
    }

    public void setValue(int value) {
        this.numberField.setValue(value);
    }

    public void storeValue(IntValueProperties intValueProperties) {
        intValueProperties.setCurrentValue(this.getValue());
    }

    protected void sliderButtonPressed() {
        JPopupMenu popup = new JPopupMenu();
        int value = this.getValue();
        this.slider.setMinimum(this.getMin());
        this.slider.setMaximum(this.getMax());
        this.slider.setValue(value);
        this.slider.setPaintTrack(true);
        popup.setLayout(new BorderLayout());
        popup.add((Component)this.slider, "Center");
        popup.add((Component)new JLabel(String.valueOf(this.getMin())), "West");
        popup.add((Component)new JLabel(String.valueOf(this.getMax())), "East");
        Rectangle bounds = this.getBounds();
        popup.show(this, 0, bounds.height);
    }

    protected void sliderChanged() {
        this.numberField.setValue(this.slider.getValue());
    }

    protected void sliderChanged(ChangeEvent e) {
        this.numberField.setValue(this.slider.getValue());
    }

    protected void upButton_actionPerformed(ActionEvent event) {
        this.numberField.Inc();
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.numberField.setToolTipText(text);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() > 0) {
            this.numberField.Dec();
        } else {
            this.numberField.Inc();
        }
    }

    public void setEnableInput(boolean enableInput) {
        this.numberField.setEnabled(enableInput);
    }

    class SymText
    implements DocumentListener {
        SymText() {
        }

        public void changedUpdate(DocumentEvent event) {
            EditableNumericSpinner.this.fireSpinnerChangedEvent(event);
        }

        public void insertUpdate(DocumentEvent event) {
            EditableNumericSpinner.this.fireSpinnerChangedEvent(event);
        }

        public void removeUpdate(DocumentEvent event) {
            EditableNumericSpinner.this.fireSpinnerChangedEvent(event);
        }
    }

    class SymAction
    implements ActionListener,
    Serializable {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == EditableNumericSpinner.this.upButton) {
                EditableNumericSpinner.this.upButton_actionPerformed(event);
            } else if (object == EditableNumericSpinner.this.downButton) {
                EditableNumericSpinner.this.downButton_actionPerformed(event);
            }
        }
    }
}

